function getSelectionFontSize() {
    if (window.getSelection) {
        var sel = window.getSelection();
        if (sel.rangeCount > 0) {
            var rng = sel.getRangeAt(0);
            var node = rng.startContainer;
            if (node.nodeType != 1) {
                node = node.parentElement;
            }
            if (node) {
                var style = window.getComputedStyle(node, null);
                var size = style.fontSize;
                var px = parseInt(size);
                return px;
            }
        }
    }
    return 0;
}

function applySelectionFontSize(size) {
    if (window.getSelection) {
        console.log('Applying size: ');
        console.log(size);
        var randomCssClass = "rangyTemp_" + (+new Date());
        console.log(randomCssClass);
        var classApplier = rangy.createCssClassApplier(randomCssClass, true);
        classApplier.applyToSelection();
        $("." + randomCssClass).css({"fontSize": size}).removeClass(randomCssClass);
    }
}

function insertImage(url) {
    if (window.getSelection) {
        var selection = window.getSelection();
        if (selection.rangeCount > 0) {
            var range = selection.getRangeAt(0);
            var img = document.createElement('img');
            img.src = url;
            
            range.deleteContents();
            range.insertNode(img);
            range.setStartAfter(img);
            range.setEndAfter(img);
            range.collapse(false);
            
            selection.removeAllRanges();
            selection.addRange(range);
        }
    }
}

function validatePlaceholder(selector) {
    var body = $(selector);
    var txt = body.children(':not(.CanaryPlaceholder, .CanarySigButton)').text().trim();
    var inner = body.contents().filter(function(){
                                     return this.nodeType == 3;
                                       }).text().trim();
    console.log('Inner: ');
    console.log(inner);
    if (txt.length == 0 && inner.length == 0) {
        body.children('.CanaryPlaceholder').show();
    } else {
        body.children('.CanaryPlaceholder').hide();
    }
}

validatePlaceholder('#CanaryBody');
validatePlaceholder('#CanarySig');

$("body").on('input', function() {
                    var messageToPost = { 'changed' : 1 };
                    window.webkit.messageHandlers.changeHandler.postMessage(messageToPost);
                    validatePlaceholder('#CanaryBody');
                    validatePlaceholder('#CanarySig');
                });

$( "body" ).keydown(
                    function() {
                    var messageToPost = { 'action' : 'keydown' };
                    window.webkit.messageHandlers.keyDownHandler.postMessage(messageToPost);
                    }
                    );
$(".CanarySigButton").click(
                            function() {
                            var messageToPost = { 'sig' : '1' };
                            window.webkit.messageHandlers.signatureHandler.postMessage(messageToPost);
                            }
                            );

$('body').hover(function(){
                 $(".CanarySigButton").fadeIn();
                 },
                 function(){
                 $(".CanarySigButton").fadeOut();
                 });

function replaceSig(sigHTML) {
    var sig = document.getElementById('CanarySig');
    if (sig) {
        sig.innerHTML = sigHTML;
    } else {
        sig = document.createElement('div');
        sig.id = 'CanarySig';
        sig.innerHTML = sigHTML;
        var quoted = document.getElementById('CanaryBlockquote');
        if (quoted) {
            document.body.insertBefore(sig, quoted);
        } else {
            document.body.appendChild(sig);
        }
    }
    $(sig).animate({ left : '0px' }, 200);
    validatePlaceholder('#CanaryBody');
    validatePlaceholder('#CanarySig');
    $(".CanarySigButton").click(
                                function() {
                                var messageToPost = { 'sig' : '1' };
                                window.webkit.messageHandlers.signatureHandler.postMessage(messageToPost);
                                }
                                );
}
